/* eslint-disable react/prop-types */
import { useEffect, useState } from 'react'
import logo from './assets/logo.png'
import emb from './assets/emb.png'
import ph from './assets/ph.png'
import temp from './assets/temp.png'
import infopark from './assets/infopark.jpg'
import './App.css'
import Chart from 'react-apexcharts';
import { database } from './util/firebase'
import { ref, onValue, set } from 'firebase/database'
function App() {
  const [ data, setData ] = useState({})

  useEffect(() => {
    const dataRef = ref(database, '/UI-1');
    const unsubscribe = onValue(dataRef, (snapshot) => {
      const value = snapshot.val();
      console.log('value : ', value, data.history["Algae-Produced"]['2025'])
      setData(value);
    })

    return () => unsubscribe();
  }, [])


  return (
    <>
      <div className='firstSection'>
        <div className='left flex-wrap'>
          <div className='header'>
            <p className='heading'>
              <span>TOTAL CARBON</span><br />
              <span>ABSORPTION</span><br />
              <span>MONTHLY</span>
            </p>
            <ToggleSwitch label={'Pump'} data={data} setData={setData} />
          </div>
          <div className="flex gap-4 flex-wrap-reverse">
            <div className='one'>
              <p className='heading'>Previous <br /> Month</p>
              <img src={ emb } alt="" />
              <p>
                <span className='font-bold text-4xl'>{ data.co2?.['prev-month'] } </span>
                <span className='text-3xl'>kg</span>
              </p>
            </div>
            <div className='two'>
              <p className='heading'>Preceding <br /> Month</p>
              <img src={ emb } alt="" />
              <p>
                <span className='font-bold text-4xl'>{ data.co2?.['prec-month'] } </span>
                <span className='text-3xl'>kg</span>
              </p>
            </div>
            <div className='three flex-1'>
              <p>
                <span className='text-2xl'>Live CO2</span><br />
                <span className='co2'>{ data.co2?.live }</span><br />
                <span className='text-2xl'>PPM</span>
              </p>
            </div>
          </div>
        </div>
        <div className="right">
          <p className='heading'>
            ALGAE PRODUCED
          </p>
          <div className='flex gap-4 justify-center flex-wrap md:flex-nowrap'>
            {/* <div className='radialChart1 one'>
              <div className='w-fit px-4'>
                <RadialChart value={75} width={ 200 } height={ 200 } trackColor={"#081A37"} trackBg={ "transparent" } hollowSize={"66%"}/>
                <p>1.27 kg</p>
              </div>
            </div> */}
            <div className='text-center one'>
              <p className='mHeading text-2xl font-nomal mb-2'>Previous <br />Month</p>
              <div className="radialChart2">
                <RadialChart value={75} width={ 200 } height={ 200 } trackColor={"#27f0198f"} trackBg={ "transparent" } hollowSize={"63%"}/>
                <p>
                  <span className='font-bold text-2xl'>{ data.algae?.['prev-month'] } </span>
                  <span className='text-xl'>kg</span>
                </p>
              </div>
            </div>
            <div className='text-center two'>
              <p className='mHeading text-2xl font-normal mb-2'>Preceding <br />Month</p>
              <div className="radialChart2">
                <RadialChart value={75} width={ 200 } height={ 200 } trackColor={"#27f0198f"} trackBg={ "transparent" } hollowSize={"63%"}/>
                <p>
                  <span className='font-bold text-2xl'>{ data.algae?.['prec-month'] } </span>
                  <span className='text-xl'>kg</span>
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className='secondSection'>
        <div className="one">
          <img src={ ph } alt="" />
          <p>{ parseFloat(data.ph).toFixed(1) }</p>
        </div>
        <div className="two">
          <img src={ temp } alt="" />
          <p>{ data.temp }&#8451;</p>
        </div>
        {/* <div className="three">
          <p>
            <span style={{ fontSize: '2.7rem', lineHeight: 1 }}>Carbon</span><br />
            <span style={{ fontSize: '2.3rem', lineHeight: 1.5 }}>Credit</span>
          </p>
          <img src="/temp.png" alt="" />
        </div> */}
        <div className="four">
          <AlgaeChart data={ data } />
        </div>
      </div>
      
      <div className="footer">
        <div className="logos">
          <img src={ logo } alt="" />
          <img className='custom ml-5' src={ infopark } alt="" />
        </div>
        <div className="content">
          <p>Equivalent to <span>1700</span><br /> Indoor Plants</p>
        </div>
      </div>
    </>
  )
}

export default App
// import React from 'react';

// eslint-disable-next-line react/prop-types
const RadialChart = ({ value, width, height, lineCap, trackBg, trackColor, gradient, hollowSize }) => {
  const options = {
    chart: {
      // height: 280,
      type: "radialBar",
    },
  
    series: [97],
    colors: [ trackColor ],
    plotOptions: {
      radialBar: {
        hollow: {
          margin: 0,
          size: hollowSize,
          // background: "#293450",
          background: "transparent",
        },
        track: {
          dropShadow: {
            enabled: true,
            top: 2,
            left: 0,
            blur: 4,
            opacity: 0.15
          },
          background: trackBg,
        },
        dataLabels: {
          name: {
            offsetY: -10,
            color: "#fff",
            fontSize: "13px",
            show: false,
          },
          value: {
            color: "#fff",
            fontSize: "30px",
            show: false
          }
        }
      }
    },
    // fill: {
    //   type: "gradient",
    //   gradient: {
    //     shade: "dark",
    //     type: "vertical",
    //     gradientToColors: ["#87D4F9"],
    //     stops: [0, 100]
    //   }
    // },
    stroke: {
      lineCap: lineCap
    },
    labels: ["Progress"]
  };

  if (gradient) {
    options.fill = {
      type: "gradient",
      gradient: {
        shade: "dark",
        type: "vertical",
        gradientToColors: [ gradient ],
        stops: [0, 100]
      }
    }
  }

  const series = [ value ]; // Percentage value for the radial chart

  return (
      <Chart options={options} series={series} type="radialBar" height={ height } width={ width } />
  );
};



const AlgaeChart = ({ data }) => {

  useEffect(() => {
    console.log(data.history?.['Algae-Produced']['2025'])
  }, [data])



  const chartOptions = {
    chart: {
      toolbar: {
        show: false, // Removes the toolbar
      },
      zoom: {
        enabled: false, // Disables zooming
      },
    },
    grid: {
      show: false, // Removes grid lines
    },
    dataLabels: {
      enabled: false, // Disables data labels
    },
    xaxis: {
      categories: [
        "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
      ],
      labels: {
        show: true, // Hides X-axis labels
        style: {
          colors: "#FFFFFF", // Custom color for X-axis labels
          fontSize: "12px",  // Optional: Change font size
          fontWeight: "bold", // Optional: Change font weight
        },
      },
      axisBorder: {
        show: true, // Hides X-axis border
      },
      axisTicks: {
        show: true, // Hides X-axis ticks
      },
    },
    yaxis: {
      min: 0,
      max: 4,
      tickAmount: 8,
      labels: {
        formatter: (value) => `${value} kg`,
        show: true, // Hides Y-axis labels
        style: {
          colors: "#FFFFFF", // Custom color for X-axis labels
          fontSize: "12px",  // Optional: Change font size
          fontWeight: "bold", // Optional: Change font weight
        },
      },
      axisBorder: {
        show: true, // Hides Y-axis border
      },
      axisTicks: {
        show: true, // Hides Y-axis ticks
      },
    },
    title: {
      text: undefined, // Removes the chart title
    },
    legend: {
      show: true, // Hides the legend
      position: "top", // Position of the legend
      horizontalAlign: "right", // Align the legend to the right
      floating: false,
      itemMargin: {
        horizontal: 10,
        vertical: 5,
      },
      labels: {
        colors: "#FFFFFF", // Legend text color
        fontSize: "14px",  // Font size for the legend
        fontWeight: "bold", // Make legend text bold
      },
    },
    tooltip: {
      enabled: true, // Disables tooltips
      theme: "dark",
    },
    stroke: {
      curve: 'straight', // Optional styling for lines
      width: 2,        // Line thickness
      // colors: ["#FFFFFF", "#FF4560"],
    },
    colors: ["#FFFFFF", "#27f019"],
    series: [
      {
        name: 'CO2 Absorbed',
        data: data.history?.["CO2-Absorbed"]?.['2025'].filter(Boolean)
      },
      {
        name: 'Algae Produced',
        data: data.history?.["Algae-Produced"]?.['2025'].filter(Boolean)
      },
    ],
  };
  return (
    <>
      <p className='relative z-10 text-3xl px-4 pt-3 font-semibold'>
        TOTAL CO2 ABSORPTION AND ALGAE PRODUCTION
      </p>

      <Chart
        options={chartOptions}
        series={chartOptions.series}
        type="line"
        width="100%"
        height="100%"
      />
    </>
  )
}


const ToggleSwitch = ({ label, data, setData }) => {
  // const { config, setConfig } = useProvider()

  const handleToggle = () => {
    console.log('Handle Toggle : ::')
    setData(prev => ({ 
      ...prev, 
      config: { 
        ...prev.config,
        status: { 
          ...prev.config?.status,
          pump: !prev.config.status.pump 
        }
      }
    }))

    const dataRef = ref(database, '/UI-1/config/status/pump');
    set(dataRef, !data.config.status.pump)
    .then(() => {
      console.log('Pump Updated')
    }).catch ((err) => {
      console.error('Update Error : ', err)
    })
  }

  return (
      <div className="flex items-center gap-4 px-8 mb-3">
          <p className="text-nowrap font-bold tracking-wider uppercase font-mono text-[#ffc934]">{ label }</p>
          <div className="toggle-switch">
              <input
                type="checkbox"
                className="checkbox"
                name={label}
                id={label}
                onChange={handleToggle}
                checked={ data.config?.status?.pump }
              />
              <label className="label" htmlFor={label}>
                <span className="inner" />
                <span className="switch" />
              </label>
          </div>
      </div>
  );
};