import { baseApi } from "./baseApi";

// Inject endpoints into the base API
export const apiSlice = baseApi.injectEndpoints({
  endpoints: (builder) => ({
    // Get device data by uniqueId
    getDeviceData: builder.query({
      query: (uniqueId) => ({
        url: "data/device",
        params: { uniqueId },
      }),
    }),
  }),
});

export const { useGetDeviceDataQuery } = apiSlice;
